package com.qboxus.tictic.viewModels

import android.content.Context
import android.content.SharedPreferences
import androidx.databinding.ObservableBoolean
import androidx.databinding.ObservableInt
import androidx.lifecycle.LiveData
import androidx.lifecycle.MutableLiveData
import androidx.lifecycle.ViewModel
import androidx.lifecycle.ViewModelProvider
import androidx.lifecycle.viewModelScope
import com.qboxus.tictic.R
import com.qboxus.tictic.apiclasses.ApiResponce
import com.qboxus.tictic.models.HomeModel
import com.qboxus.tictic.repositories.VideosRepository
import com.qboxus.tictic.simpleclasses.Functions
import com.qboxus.tictic.simpleclasses.Variables
import kotlinx.coroutines.launch
import org.json.JSONObject

class PrivateVideosViewModel(
    private val context: Context,
    private val videoRepository: VideosRepository

) : ViewModel(){

    lateinit var sharedPreferences: SharedPreferences
    init {
        sharedPreferences=Functions.getSharedPreference(context)
    }




    var ispostFinsh = false
    var isMyProfile = true
    var isApiRun = false


    var pageCount: ObservableInt = ObservableInt(0)

    val _videosLiveData: MutableLiveData<ApiResponce<ArrayList<HomeModel>>> = MutableLiveData()
    val videosLiveData: LiveData<ApiResponce<ArrayList<HomeModel>>> get() = _videosLiveData

    fun getUserVideo(){
        viewModelScope.launch {

            isApiRun=true
            val params = JSONObject().apply {
                put("user_id", sharedPreferences.getString(Variables.U_ID, ""));
                put("starting_point", pageCount.get().toString())

            }
            videoRepository.showVideosAgainstUserID(params,"private",_videosLiveData)
        }
    }


    var dataLayoutVisibility = ObservableBoolean(false)
    var noDataLayoutVisibility = ObservableBoolean(false)
    var loadMoreProgressVisibility = ObservableBoolean(false)

    private val _noDataMsgTxt = MutableLiveData<String>()
    val noDataMsgTxt: LiveData<String> get() = _noDataMsgTxt

    private val _noDataTitleTxt = MutableLiveData<String>()
    val noDataTitleTxt: LiveData<String> get() = _noDataTitleTxt
    fun showNoDataView(){
        dataLayoutVisibility.set(false)
        noDataLayoutVisibility.set(true)
        _noDataTitleTxt.value = context.getString(R.string.your_private_video)
        _noDataMsgTxt.value=context.getString(R.string.to_make_your_video_visible_to_yourself_only)

    }

    fun showDataView(){
        dataLayoutVisibility.set(true)
        noDataLayoutVisibility.set(false)
    }



}


class PrivateVideoFactory(
    private val context: Context,
    private val videosRepository: VideosRepository
) : ViewModelProvider.Factory {
    override fun <T : ViewModel> create(modelClass: Class<T>): T {
        if (modelClass.isAssignableFrom(PrivateVideosViewModel::class.java)) {
            return PrivateVideosViewModel(context,videosRepository) as T
        }
        throw IllegalArgumentException("Unknown ViewModel class")
    }
}